<?php
require_once __DIR__ . '/../../config/db.php';
$pdo = db();
$rows = $pdo->query("SELECT * FROM projects ORDER BY created_at DESC")->fetchAll();
?>
<div class="container my-4">
  <h2 class="mb-3">Proyek</h2>
  <div class="row g-3">
  <?php foreach($rows as $r): ?>
    <div class="col-md-4">
      <div class="card h-100">
        <img src="<?php echo e($r['image'] ?: 'https://picsum.photos/600/400'); ?>" class="card-img-top card-cover" alt="">
        <div class="card-body d-flex flex-column">
          <h5 class="card-title"><?php echo e($r['title']); ?></h5>
          <p class="card-text flex-grow-1"><?php echo nl2br(e(mb_strimwidth($r['description'] ?? '',0,160,'...'))); ?></p>
          <?php if(!empty($r['link'])): ?>
            <a class="btn btn-outline-success mt-auto" href="<?php echo e($r['link']); ?>" target="_blank" rel="noopener">Lihat</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endforeach; if(empty($rows)): ?>
    <div class="col-12"><div class="alert alert-info">Belum ada proyek. Tambahkan dari halaman admin.</div></div>
  <?php endif; ?>
  </div>
</div>
