<?php
function db(){
  static $pdo;
  if($pdo) return $pdo;
  $cfg = require __DIR__ . '/config.php';
  $dsn = 'mysql:host=' . $cfg['DB_HOST'] . ';dbname=' . $cfg['DB_NAME'] . ';charset=utf8mb4';
  try{
    $pdo = new PDO($dsn, $cfg['DB_USER'], $cfg['DB_PASS'], [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
  }catch(PDOException $e){
    http_response_code(500);
    die('DB error: ' . $e->getMessage());
  }
  return $pdo;
}
