<?php
// admin/upload_image.php
require_once __DIR__ . '/../config/helpers.php';

header('Content-Type: application/json; charset=utf-8');

$targetDir = __DIR__ . '/../public/uploads/news/editor';
$baseUrl   = rtrim(dirname($_SERVER['SCRIPT_NAME'], 1), '/\\'); // /admin
$publicUrl = $baseUrl ? substr($baseUrl, 0, strrpos($baseUrl, '/')) : ''; // root app
// Helper base_url jika ada di helpers.php, lebih aman:
if (function_exists('base_url')) {
  $urlBuilder = function($path){ return base_url($path); };
} else {
  $urlBuilder = function($path){
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host   = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $base   = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? '/admin/upload_image.php'), '/\\');
    $root   = rtrim(preg_replace('~/admin$~','',$base), '/\\'); // kira2 ke /public
    return $scheme.'://'.$host.$root.'/'.$path;
  };
}

if (!is_dir($targetDir)) @mkdir($targetDir, 0775, true);

try {
  if (empty($_FILES['file']['name'])) throw new Exception('Tidak ada file.');
  $f = $_FILES['file'];
  if ($f['error'] !== UPLOAD_ERR_OK) throw new Exception('Upload error code: '.$f['error']);
  $name = $f['name'];
  $ext  = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  if (!in_array($ext, ['jpg','jpeg','png','webp'])) throw new Exception('Format wajib JPG/PNG/WEBP.');

  if ($f['size'] > 3*1024*1024) throw new Exception('Maks 3MB.');
  if (!is_uploaded_file($f['tmp_name'])) throw new Exception('Bukan upload valid.');

  $new  = date('Ymd_His').'_'.$ext.'_'.substr(sha1($name.random_int(1,999999)),0,8).'.'.$ext;
  $dest = rtrim($targetDir,'/').'/'.$new;
  if (!@move_uploaded_file($f['tmp_name'], $dest)) throw new Exception('Gagal simpan file.');

  // URL publik
  $location = 'uploads/news/editor/'.$new;
  echo json_encode(['location' => $urlBuilder($location)]);
} catch (Throwable $e) {
  http_response_code(400);
  echo json_encode(['error' => $e->getMessage()]);
}
