<?php
require_once __DIR__ . '/_layout_top.php';
$pdo = db();
$pc = $pdo->query("SELECT COUNT(*) c FROM projects")->fetch()['c'] ?? 0;
$mc = $pdo->query("SELECT COUNT(*) c FROM contact_messages")->fetch()['c'] ?? 0;
$latest = $pdo->query("SELECT id,title,created_at FROM projects ORDER BY created_at DESC LIMIT 5")->fetchAll();
?>
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
  <div class="bg-white rounded-xl border border-gray-200 p-4">
    <div class="text-sm text-gray-500">Total Proyek</div>
    <div class="mt-2 flex items-end justify-between">
      <div class="text-3xl font-semibold"><?php echo (int)$pc ?></div>
      <div class="w-10 h-10 rounded-lg bg-blue-50 text-blue-600 grid place-content-center">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h18M3 12h18M3 17h18"/></svg>
      </div>
    </div>
  </div>
  <div class="bg-white rounded-xl border border-gray-200 p-4">
    <div class="text-sm text-gray-500">Pesan Masuk</div>
    <div class="mt-2 flex items-end justify-between">
      <div class="text-3xl font-semibold"><?php echo (int)$mc ?></div>
      <div class="w-10 h-10 rounded-lg bg-emerald-50 text-emerald-600 grid place-content-center">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8m-9 4v8"/></svg>
      </div>
    </div>
  </div>
  <div class="bg-white rounded-xl border border-gray-200 p-4">
    <div class="text-sm text-gray-500">Status</div>
    <div class="mt-2 flex items-end justify-between">
      <div class="text-3xl font-semibold">Online</div>
      <div class="w-10 h-10 rounded-lg bg-violet-50 text-violet-600 grid place-content-center">
        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M2 5a2 2 0 012-2h2a2 2 0 012 2v2H2V5zm0 8h6v2a2 2 0 01-2 2H4a2 2 0 01-2-2v-2zm16-6V5a2 2 0 00-2-2h-2a2 2 0 00-2 2v2h6zM10 11h8v2a2 2 0 01-2 2h-6v-4z"/></svg>
      </div>
    </div>
  </div>
  <div class="bg-white rounded-xl border border-gray-200 p-4">
    <div class="text-sm text-gray-500">Versi</div>
    <div class="mt-2 flex items-end justify-between">
      <div class="text-3xl font-semibold">v1.2</div>
      <div class="w-10 h-10 rounded-lg bg-amber-50 text-amber-600 grid place-content-center">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
      </div>
    </div>
  </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
  <div class="lg:col-span-2 bg-white rounded-xl border border-gray-200">
    <div class="p-4 border-b flex items-center justify-between">
      <h3 class="font-semibold">Proyek Terbaru</h3>
      <a href="projects.php" class="text-sm text-primary hover:underline">Kelola</a>
    </div>
    <div class="p-0 overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead class="bg-gray-50">
          <tr class="text-left text-gray-500">
            <th class="px-4 py-2">ID</th>
            <th class="px-4 py-2">Judul</th>
            <th class="px-4 py-2">Dibuat</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach($latest as $r): ?>
          <tr class="border-t">
            <td class="px-4 py-2"><?php echo (int)$r['id'] ?></td>
            <td class="px-4 py-2"><?php echo e($r['title']) ?></td>
            <td class="px-4 py-2 text-gray-500"><?php echo e($r['created_at']) ?></td>
          </tr>
        <?php endforeach; if(empty($latest)): ?>
          <tr><td colspan="3" class="px-4 py-6 text-center text-gray-500">Belum ada data.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="bg-white rounded-xl border border-gray-200">
    <div class="p-4 border-b"><h3 class="font-semibold">Quick Actions</h3></div>
    <div class="p-4 grid grid-cols-1 gap-3">
      <a href="projects.php" class="px-3 py-2 rounded-lg border hover:bg-gray-50 text-sm">Tambah Proyek</a>
      <a href="profile_edit.php" class="px-3 py-2 rounded-lg border hover:bg-gray-50 text-sm">Edit Profile</a>
      <a href="about_edit.php" class="px-3 py-2 rounded-lg border hover:bg-gray-50 text-sm">Edit About</a>
      <a href="contacts.php" class="px-3 py-2 rounded-lg border hover:bg-gray-50 text-sm">Lihat Pesan</a>
    </div>
  </div>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
