
(function(){
  const links = document.querySelectorAll('#sidebar .nav a');
  const sections = [...links].map(a => document.querySelector(a.getAttribute('href'))).filter(Boolean);
  const onScroll = () => {
    const pos = window.scrollY + 120;
    let current = sections[0];
    for(const sec of sections){
      if(sec.offsetTop <= pos) current = sec;
    }
    links.forEach(a => a.classList.toggle('active', a.getAttribute('href') === '#' + current.id));
  };
  window.addEventListener('scroll', onScroll, {passive:true});
  onScroll();
})();
