<?php
require_once __DIR__ . '/../config/helpers.php';
require_once __DIR__ . '/../config/db.php';
require_login();
$cfg = require __DIR__ . '/../config/config.php';
?>
<!doctype html>
<html lang="id" class="h-full bg-gray-50">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin — <?php echo e($cfg['APP_NAME']) ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>tailwind.config = { theme:{ extend:{ colors:{ primary:'#0ea5e9' }}}};</script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style> body{font-family:Inter,ui-sans-serif,system-ui;} .scroll{scrollbar-width:thin;} </style>
</head>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>

<body class="h-full">
<div class="min-h-screen flex">
  <!-- Sidebar -->
  <aside class="hidden md:flex w-64 flex-col bg-white border-r border-gray-200">
    <div class="h-16 flex items-center px-4 border-b">
      <div class="flex items-center gap-2">
        <div class="w-8 h-8 rounded-lg bg-primary/10 grid place-content-center text-primary font-bold">F</div>
        <span class="font-semibold text-gray-800">Fortopolio Admin</span>
      </div>
    </div>
    <nav class="flex-1 p-3 space-y-1">
      <a href="index.php" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-100 text-gray-700 <?php echo basename($_SERVER['PHP_SELF'])==='index.php'?'bg-gray-100 font-semibold':''; ?>">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0h6"/></svg>
        Dashboard
      </a>
      <a href="profile_edit.php" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-100 text-gray-700 <?php echo basename($_SERVER['PHP_SELF'])==='profile_edit.php'?'bg-gray-100 font-semibold':''; ?>">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A4 4 0 018 17h8a4 4 0 012.879 1.804M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
        Profile
      </a>
      <a href="projects.php" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-100 text-gray-700 <?php echo basename($_SERVER['PHP_SELF'])==='projects.php'?'bg-gray-100 font-semibold':''; ?>">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h18M3 12h18M3 17h18"/></svg>
        Projects
      </a>
      <a href="news.php" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-100 text-gray-700 <?php echo basename($_SERVER['PHP_SELF'])==='news.php'?'bg-gray-100 font-semibold':''; ?>">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h18M3 12h18M3 17h18"/></svg>
        News 
      </a>
      <a href="about_edit.php" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-100 text-gray-700 <?php echo basename($_SERVER['PHP_SELF'])==='about_edit.php'?'bg-gray-100 font-semibold':''; ?>">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3-1.79-3-4s1.343-4 3-4 3 1.79 3 4-1.343 4-3 4zm0 0v8m0 0c-3.866 0-7 1.79-7 4h14c0-2.21-3.134-4-7-4z"/></svg>
        Tentang Saya
      </a>
      <a href="contacts.php" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-100 text-gray-700 <?php echo basename($_SERVER['PHP_SELF'])==='contacts.php'?'bg-gray-100 font-semibold':''; ?>">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8m-9 4v8"/></svg>
        Pesan Masuk
      </a>
       <a href="coment.php" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-100 text-gray-700 <?php echo basename($_SERVER['PHP_SELF'])==='coment.php'?'bg-gray-100 font-semibold':''; ?>">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8m-9 4v8"/></svg>
        Komentar masuk
      </a>
    </nav>
    <div class="p-3 border-t">
      <a href="logout.php" class="w-full inline-flex items-center justify-center px-3 py-2 text-sm font-medium rounded-lg bg-red-50 text-red-700 hover:bg-red-100">Logout</a>
    </div>
  </aside>

  <!-- Main -->
  <div class="flex-1 flex flex-col">
    <!-- Top bar -->
    <header class="h-16 bg-white border-b border-gray-200 flex items-center px-4 justify-between">
      <form class="hidden md:block w-96">
        <label class="sr-only">Cari</label>
        <div class="relative">
          <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-4.35-4.35M10 18a8 8 0 100-16 8 8 0 000 16z"/></svg>
          </span>
          <input class="w-full pl-10 pr-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-primary/40" placeholder="Cari sesuatu..." />
        </div>
      </form>
      <div class="flex items-center gap-3">
        <a href="<?php echo e(base_url('../public/index.php')) ?>" class="text-sm text-primary font-medium hover:underline">Lihat Situs</a>
        <div class="w-9 h-9 rounded-full bg-primary/10 grid place-content-center text-primary font-bold">A</div>
      </div>
    </header>

    <!-- Content wrapper -->
    <main class="p-4 md:p-6">
